#ifndef __CScrollEvent__
#define __CScrollEvent__

#include <MathTools/CRect.hpp>
using Exponent::MathTools::CRect;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Events
		{
			/**
			 * @interface CScrollEvent CScrollEvent.hpp
			 * @brief Allows for responding to scroll actions
			 *
			 * @date 29/09/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 * @version 1.0.1 Changed to fit new scrolling system
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CScrollEvent.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			class CScrollEvent : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * @enum EScrollDirection The direction of scrolling
				 * @brief The direction
				 */
				enum EScrollDirection
				{
					e_scrollVertical = 0,		/**< Vertical scrolling  */
					e_scrollHorizontal			/**< Horizontal scrolling */
				};

//	===========================================================================

				/**
				 * Construction
				 * @param direction The direction of travel
				 * @param viewPort The new viewport to display
				 */
				CScrollEvent(const EScrollDirection direction, const CRect &viewPort);

				/**
				 * Destruction
				 */
				virtual ~CScrollEvent();

//	===========================================================================

				/**
				 * Set the viewport
				 * @param viewPort The view port area
				 */
				void setViewPort(const CRect &viewPort) { m_viewPort = viewPort; }

				/**
				 * Set the direction
				 * @param direction The direction of travel
				 */
				void setDirection(const EScrollDirection direction) { m_direction = direction; }

//	===========================================================================

				/**
				 * Get the direction
				 * @retval EScrollDirection The direction of travel 
				 */
				EScrollDirection getDirection() const { return m_direction; }

				/**
				 * Get the viewport
				 * @retval const CRect& the viewport area
				 */
				const CRect &getViewPort() const { return m_viewPort; }

//	===========================================================================

			protected:

//	===========================================================================

				EScrollDirection m_direction;		/**< Direction of movement */
				CRect m_viewPort;					/**< The viewable area */
			};
		}
	}
}
#endif	// End of CScrollEvent.hpp